Contributing
===
When sending a "Pull Request", committing code, or otherwise sending,
submitting, or transmitting code in any other way, please place a
[GNU Affero General Public License](http://www.gnu.org/licenses/agpl.html)
notice or any compatible license notice at the top of the code (if one isn't
already present) and assign your contribution's copyright to yourself or
"Jacob Barkdull". This gives me the necessary rights to distribute your
contribution in HashOver under the GNU Affero General Public License.

HashOver is partially written in JavaScript, plain, standard, non-jQuery
JavaScript. If your contribution improves or adds new functionality to the
JavaScipt portions of HashOver, your contribution must also be written in plain,
standard, non-jQuery JavaScript. Contributions using or assuming the presence of
jQuery, Underscore, AngularJS, Prototype, React, Node.js, or any other
abstraction layer, library, and/or framework will be rejected.


Focus of this release
---
HashOver [version 1.0](https://github.com/jacobwb/hashover) consists of code
written by [one person](http://tildehash.com/?page=author) over the course of
five years, come March the 29th 2014. Moreover, HashOver 1.0 was my first
serious use of JavaScript and my first PHP project of such complexity. Those two
facts should trigger obvious concerns about HashOver's performance, efficiency,
and security. With that in mind, version 2.0 will be the next release, and will
focus on improving nothing but the following areas.

- Security
- Performance
- Code efficiency
- Deployment
- Data storage format
- Backwards and forwards compatibility
- Operating system support
- Aesthetics and graphics
- Graphic scalability on high-density displays
- Code readability
- Bug fixes

This means the possibility of new features in version 2.0 is next to nil, and
contributions via GitHub and/or e-mail that add new features will be rejected,
at least for the time being. Improvements to existing functionality and
aesthetics will be accepted. New features will be accepted and available in
version 2.x releases.
